--TODO

--Cameras
--Teleporter/Bank Lights 
--Look into creating a new class for the Invader to ally with Monsters

--known bugs

--Dead players at round end stay dead instead of spawning on the ship (may delay them getting into the next match by several seconds)
--Players may spawn on the wrong side of the ship initially (this will work fine on additional spawns)


Triggers = {}
CollectionsUsed = { 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,31 }

--variables
timer = -1 
RedTeam = 0
BluTeam = 0
StartingZone = 0
ZoneChangeDirection = 0
ZoneChanges = 0
masterMonsterCount = 21 --number of combatants per team
maxScores = 75 --score to summon primeval 
masterRespawnTimer = 210 --number of ticks before respawn from the ship (30ticks a second)
invasionInterval = 1050 --number of ticks between invasions once Primeval has spawned (30 ticks a second)
invasionDuration = 900 --number of ticks invasions last (30 ticks a second)
invasionThreshold = 25 --score interval that invasion portal activats at (does not require that amount of motes in a single bank)
invaderShieldAmount = 150 --amount of health added to the invader player (removed on end of invasion)
primevalSpawnDelay = 90 --amount of ticks between maxScores being reached and Primeval actually spawning (30 ticks a second)
primevalMaxHealth = 1000 -- (this doesn't work)
primevalHealthOnKill = 100 --amount of health added to the Primeval if an Invader kills a player 
small_blocker = 5 --minimum motes banked at once to summon a small blocker
medium_blocker = 10 --minimum motes banked at once to summon a medium blocker
large_blocker = 15 --minimum motes banked at once to summon a large blocker
regenTime = 90 --amount of ticks that need to pass after a player takes damage without additional damage being taken for health to being regen (30 ticks a second)
moteLife = 450 --amount of ticks that motes "keys" will remain on the ground before despawning (30 ticks a second)
TeleporterLight = nil -- (this doesn't work)
gameLoaded = false
round_end = 0
drifter_spawned = 0
red_squad = 0 --used to keep squads in sync between red/blu
blu_squad = 0 --used to keep squads in sync between red/blu
sync_squad = 0 --used to keep squads in sync between red/blu
combatant_grunt = {} --stores the grunts for the current match (populated when faction is chosen)
combatant_anchor = {} --stores the anchors for the current match (populated when faction is chosen)
combatant_special = {} --stores all other combatants for the current match (populated when faction is chosen)
spawned_squads = {} --used to keep squads in sync between red/blu
squad = nil
--myCamera = 0

--(factions physics/organization created by liacrow!) 

--Lh'owon:

LhowonGrunts = {
"major tick",
"tiny pfhor",
"tiny pfhor",
"tiny pfhor"
}
LhowonAnchors = {
"kamikaze tick",
"tiny yeti",
"tiny yeti",
"tiny yeti",
}
LhowonSpecial = {
--Catch up Targets
"minor tick",
"tiny bob",
--Blockers
"sewage yeti",
"water yeti",
"lava yeti",
--Envoys (Henchmen)
"possessed drone",
--Primeval (Boss)
"big minor drone"
}

--Humans + S'pht

HumanGrunts = {
"blue bob",
"blue vacbob",
"blue bob",
"blue vacbob"
}
HumanAnchors = {
"security bob",
"security bob",
"security bob",
"security bob"
}
HumanSpecial = {
--Catch up Targets
"green bob", 
"green vacbob",
--Blockers
"minor compiler",
"minor invisible compiler",
"major compiler",
--Envoys (Henchmen)
"major defender",
--Primeval (Boss)
"big major drone"
}
--Pfhor + Slaves

PfhorGrunts = {
"minor fighter",
"minor hunter",
"minor trooper",
"minor compiler",
}
PfhorAnchors = {
"major projectile fighter",
"major hunter",
"major trooper",
"major compiler"
}
PfhorSpecial = {
--Catch up Targets
"minor drone",
"major drone",
--Blockers
"minor cyborg",
"major flame cyborg",
"mother of all cyborgs",
--Envoys (Henchmen)
"major enforcer",
--Primeval (Boss)
"minor juggernaut"
}


function Triggers.init()
	RedTeam = Cameras.new()
	BluTeam = Cameras.new()
	StartingZone = Game.global_random(2) + 1
	ZoneChangeDirection = (Game.global_random(1) * 2) - 1
	ZoneChanges = Game.global_random(1) + 1
	for m in MonsterTypes() do
		for n in MonsterClasses() do
			m.enemies["player"]=true
			m.friends["player"]=false
			if n ~= "player" then
				m.friends[n]=true
				m.enemies[n]=false
			end
		end
	end
	setUpTeams(RedTeam, "red")
	setUpTeams(BluTeam, "blue")
	--setUpStragglers()
	setUpPlayers()
	setUpZones()
	factionSelect()
	gameLoaded = true
	--Created a light to indicate teleporter active state NEED TO FIX THIS STILL
	TeleporterLight = Lights.new("normal")
		TeleporterLight.active = true
		TeleporterLight.states["primary active"].intensity = 1
		TeleporterLight.states["primary active"].period = 30
		TeleporterLight.states["primary active"].light_function = "flicker"
		TeleporterLight.states["secondary active"].intensity = 0
		TeleporterLight.states["secondary active"].period = 30
		TeleporterLight.states["secondary active"].light_function = "flicker"
	--Created a light to indicate mote depositMotes
	BankLight = Lights.new("normal")
		BankLight.states["primary active"].intensity = 1
		BankLight.states["primary active"].period = 10
		BankLight.states["primary active"].light_function = "constant"
	
end

function setUpTeams(team, color)
	team._color = color
	team._currentlyInvading = false
	team._invader = 0
	team._invaderMonsterIndex = -1
	team._invasionCount = 0
	team._timeOfLastInvasion = 0
	team._teleporterState = -1
	team._score = 0
	team._roundsWon = 0
	team._currentMonsterSpawnZone = StartingZone
	team._monsterCount = 0
	team._spawningDudes = false
	team._blockerCount = 0
	team._envoysKilled = 0
	team._primeState = -1
	team._prime = 0
	team._primeSpawnDelay = primevalSpawnDelay
	team._teleporterLoc = 0
	team._bankLoc = 0
	team._teamSpawn = {}
	team._shipSpawn = 0
	team._spawnZone1 = {}
	team._spawnZone2 = {}
	team._spawnZone3 = {}
	team._heavyAmmo = {}
	team._ammoTimer = -1
	team._highValueTarget = 0
	if color == "red" then
		team._enemyTeam = BluTeam
	else
		team._enemyTeam = RedTeam
	end
end

function setUpZones()
	for a in Annotations() do
		if a.text == "red_teleporter" then
			RedTeam._teleporterLoc = a.polygon
			a.text = ""
		elseif a.text == "blu_teleporter" then
			BluTeam._teleporterLoc = a.polygon
			a.text = ""
		elseif a.text == "red_bank" then
			RedTeam._bankLoc = a.polygon
			a.text = ""
		elseif a.text == "blu_bank" then
			BluTeam._bankLoc = a.polygon
			a.text = ""
		elseif a.text == "red_ship" then
			RedTeam._shipSpawn = a.polygon
			a.text = ""
		elseif a.text == "blu_ship" then 
			BluTeam._shipSpawn = a.polygon
			a.text = ""		
		elseif a.text == "red_spawn" then 
			table.insert(RedTeam._teamSpawn, a.polygon)
			a.text = ""
		elseif a.text == "blu_spawn" then 
			table.insert(BluTeam._teamSpawn, a.polygon)
			a.text = ""
		elseif a.text == "red_zone1" then 
			table.insert(RedTeam._spawnZone1, a.polygon)
			a.text = ""
		elseif a.text == "red_zone2" then 
			table.insert(RedTeam._spawnZone2, a.polygon)
			a.text = ""
		elseif a.text == "red_zone3" then 
			table.insert(RedTeam._spawnZone3, a.polygon)
			a.text = ""
		elseif a.text == "blu_zone1" then 
			table.insert(BluTeam._spawnZone1, a.polygon)
			a.text = ""
		elseif a.text == "blu_zone2" then 
			table.insert(BluTeam._spawnZone2, a.polygon)
			a.text = ""
		elseif a.text == "blu_zone3" then 
			table.insert(BluTeam._spawnZone3, a.polygon)
			a.text = ""
		elseif a.text == "red_ammo" then
			table.insert(RedTeam._heavyAmmo, a.polygon)
			a.text = ""
		elseif a.text == "blu_ammo" then
			table.insert(BluTeam._heavyAmmo, a.polygon)
			a.text = ""
		elseif a.text == "drifter" then
			drifter_spawn = a.polygon
			a.text = ""
		elseif a.text == "crusher" then 
			monster_crusher = a.polygon
			a.text = ""
		end	
	end
end


function drifterSpawn()
	
	if drifter_spawned == 0 then
	Monsters.new(drifter_spawn.x, drifter_spawn.y, (0), drifter_spawn, ("explodavacbob"))
	drifter_spawned = 1
	
	end
end

function factionSelect()

	faction = Game.random(3) 
	Players.print("faction ="..faction)
	if faction == 0 then 
		for k,v in ipairs(LhowonGrunts) do 
		table.insert(combatant_grunt, v)
		end
		for k,v in ipairs(LhowonAnchors) do 
		table.insert(combatant_anchor, v)
		end
		for k,v in ipairs(LhowonSpecial) do
		table.insert(combatant_special, v)
		end
	elseif faction == 1 then
		for k,v in ipairs(HumanGrunts) do 
		table.insert(combatant_grunt, v)
		end
		for k,v in ipairs(HumanAnchors) do 
		table.insert(combatant_anchor, v)
		end
		for k,v in ipairs(HumanSpecial) do
		table.insert(combatant_special, v)
		end
	elseif faction == 2 then
		for k,v in ipairs(PfhorGrunts) do 
		table.insert(combatant_grunt, v)
		end
		for k,v in ipairs(PfhorAnchors) do 
		table.insert(combatant_anchor, v)
		end
		for k,v in ipairs(PfhorSpecial) do
		table.insert(combatant_special, v)
		end
	end
end

function setUpPlayers()
    for p in Players() do
        p._isInvader = false
        p._invasionTimer = 0
        p._invaderKillCount = 0
        p._respawnTimer = masterRespawnTimer
        if p.team == "red" then
            p._playerTeam = RedTeam
            p.color = "red"
        elseif p.team == "blue" or p.color == "blue" then
            p._playerTeam = BluTeam
            p.team = "blue"
            p.color = "blue"
        elseif p.color == "red" then
            p._playerTeam = RedTeam
            p.team = "red"
        elseif p.index % 2 == 0 then
            p._playerTeam = RedTeam
            p.team = "red"
            p.color = "red"
        else 
            p._playerTeam = BluTeam
            p.team = "blue"
            p.color = "blue"
        end
    end
end

function setUpCompass()
	for p in Players() do
		p.compass.lua = true
		if p.items["key"] > 0 and p._playerTeam._blockerCount == 0 then
		p.compass.beacon = true
		p.compass.x = p._playerTeam._bankLoc.x
		p.compass.y = p._playerTeam._bankLoc.y
		elseif p.items["key"] == 0 then
		p.compass.beacon = false
		end
	end
end

function setUpMonstersTeam(monster)
	monster._isRegistered = 0
	for m in Monsters() do 
		for k,v in ipairs(RedTeam._spawnZone1) and ipairs(RedTeam._spawnZone2) and ipairs(RedTeam._spawnZone3) do 
			if m.polygon == v and monster._isRegistered == 0 then
			RedTeam._monsterCount = RedTeam._monsterCount + 1
			monster._isRegistered = 1
			monster._Team = RedTeam
			end
		end
		for k,v in ipairs(BluTeam._spawnZone1) and ipairs(BluTeam._spawnZone2) and ipairs(BluTeam._spawnZone3) do 
			if m.polygon == v and monster._isRegistered == 0 then
			BluTeam._monsterCount = RedTeam._monsterCount + 1
			monster._isRegistered = 1
			monster._Team = BluTeam
			end
		end
		
	end
end

function givePlayerWeapons(player)
	player.items["fusion pistol"] = 1
	player.items["fusion pistol ammo"] = 1
	player.items["assault rifle"] = 1
	--player.items["missile launcher"] = 1
	--player.items["alien weapon"] = 1
	--player.items["flamethrower"] = 1
	player.items["shotgun"] = 1 
	player.items["smg"] = 1
end

function ammoTimer(team)
	team._ammoTimer = team._ammoTimer + 1
end

function spawnHeavyAmmo(team)
	if team._ammoTimer == 900 then
		heavy_weapon = Game.random(3)	
		for k,v in ipairs(team._heavyAmmo) do
			for i in Items() do
				if i.polygon == v then
					i:delete()
				end
			end		
			if heavy_weapon == 0 then 
				Items.new(v.x, v.y, .10, v, "missile launcher")
			elseif heavy_weapon == 1 then 
				Items.new(v.x, v.y, .10, v, "alien weapon")
			elseif heavy_weapon == 2 then 
				Items.new(v.x, v.y, .10, v, "flamethrower")
			end 
			team._ammoTimer = 0
		end
	end
end

function Triggers.idle()	
	if gameLoaded == true then
		run_game()
		round_timer()
	end	 
end

function run_game()
	
	drifterSpawn()
	spawnDudes()
	updateTeleporters(RedTeam)
	updateTeleporters(BluTeam)
	--convertWeaponToAmmo(player, item)
	deleteEmptyHeavy()
	ammoTimer(RedTeam)
	ammoTimer(BluTeam)
	spawnHeavyAmmo(RedTeam)
	spawnHeavyAmmo(BluTeam)
	highValueTarget(RedTeam)
	highValueTarget(BluTeam)
	updatePotentialScore(RedTeam)
	updatePotentialScore(BluTeam)
	updateTeleporterLights(RedTeam)
	updateTeleporterLights(BluTeam)
	for m in Monsters() do
		if timer % 16 == 0 then
		blockerWaypoint(m)
		end
	end
	--setUpMonstersTeam(monster)
	for p in Players() do
		respawns(p)
		health_regen(p)
		depositMotes(p)		
		invasions(p)	
		notifications(p)
		setUpCompass(p)		
	end
	for i in Items() do
		item_life(i)
	end
	primeval(RedTeam)
	primeval(BluTeam)
	
end

function spawnDudes()
    if RedTeam._monsterCount < 8 and RedTeam._spawningDudes == false then--and RedTeam._primeState == -1 then
		
		setUpNextSpawnZone(RedTeam)
        RedTeam._spawningDudes = true
        while RedTeam._monsterCount < masterMonsterCount do
		red_squad = red_squad + 1
			if red_squad > sync_squad then
			squad = Game.random(4) + 1
			--Players.print("squad ="..squad)
			sync_squad = sync_squad + 1
			table.insert(spawned_squads, squad)
			elseif red_squad <= sync_squad then
			squad = spawned_squads[red_squad]
			--Players.print("squad ="..squad)
		end
            spawnDudesHelper(RedTeam)
        end
        RedTeam._spawningDudes = false
    end
    if BluTeam._monsterCount < 8 and BluTeam._spawningDudes == false then--and BluTeam._primeState == -1 then
		
		setUpNextSpawnZone(BluTeam)
        BluTeam._spawningDudes = true
        while BluTeam._monsterCount < masterMonsterCount do
		blu_squad = blu_squad + 1
			if blu_squad > sync_squad then
			squad = Game.random(4) + 1
			--Players.print("squad ="..squad)
			sync_squad = sync_squad + 1
			table.insert(spawned_squads, squad)
			elseif blu_squad <= sync_squad then
			squad = spawned_squads[blu_squad]
			--Players.print("squad ="..squad)
		end
			spawnDudesHelper(BluTeam)
        end
        BluTeam._spawningDudes = false
    end
end

function setUpNextSpawnZone(team)
	team._currentMonsterSpawnZone = team._currentMonsterSpawnZone + (ZoneChangeDirection * ZoneChanges)
	if team._currentMonsterSpawnZone >= 4 then
		team._currentMonsterSpawnZone = team._currentMonsterSpawnZone - 3
	elseif team._currentMonsterSpawnZone <= 0 then
		team._currentMonsterSpawnZone = team._currentMonsterSpawnZone + 3
	end
end

function spawnDudesHelper(team)
	
	spawn = pickSpawnLocation(team)
	Monsters.new(spawn.x, spawn.y, (0), spawn, (combatant_grunt[squad]))
	
	spawn = pickSpawnLocation(team)
	Monsters.new(spawn.x, spawn.y, (0), spawn, (combatant_grunt[squad]))
	
	spawn = pickSpawnLocation(team)
	Monsters.new(spawn.x, spawn.y, (0), spawn, (combatant_grunt[squad]))
	
	spawn = pickSpawnLocation(team)
	Monsters.new(spawn.x, spawn.y, (0), spawn, (combatant_grunt[squad]))
		
	spawn = pickSpawnLocation(team)
	Monsters.new(spawn.x, spawn.y, (0), spawn, (combatant_grunt[squad]))
		
	spawn = pickSpawnLocation(team)
	Monsters.new(spawn.x, spawn.y, (0), spawn, (combatant_anchor[squad]))
		 
	spawn = pickSpawnLocation(team)
	Monsters.new(spawn.x, spawn.y, (0), spawn, (combatant_anchor[squad]))
		
	team._monsterCount = team._monsterCount + 7
	for m in Monsters() do
		if m.type ~= "player" then 
			m.active = true
		end
	end
end

function pickSpawnLocation(team)
	if team._currentMonsterSpawnZone == 1 then
		zone = team._spawnZone1
		return zone[Game.global_random(#zone) + 1]
	elseif team._currentMonsterSpawnZone == 2 then
		zone = team._spawnZone2
		return zone[Game.global_random(#zone) + 1]
	elseif team._currentMonsterSpawnZone == 3 then
		zone = team._spawnZone3
		return zone[Game.global_random(#zone) + 1]
	end
end

function updateTeleporters(team)
	if (not team._currentlyInvading) and 
	((team._score / (team._invasionCount + 1)) >= invasionThreshold or team._enemyTeam._primeState == 1 or team._primeState == 1) and 
	(timer - team._timeOfLastInvasion) >= invasionInterval and 
	(team._teleporterState == -1) then
		team._teleporterState = 1
		if (team._color == "red") then
			Players.print("Red teleporter is active!")
		elseif (team._color == "blue") then
			Players.print("Blu teleporter is active!")
		end
	end
end

function updateTeleporterLights(team)
	for p in Polygons() do
		if team._teleporterState == 1 and p.index == team._teleporterLoc then
			p.floor.light = TeleporterLight
		elseif team._teleporterState == 0 and p.idex == team._teleporterLoc then
			p.floor.light = nil 
		end
	end
	--[[for p in Polygons() do
		if team._teleporterState == 1 and p.type == normal then
		p.floor.light = TeleporterLight
		end
	end--]]
end

function respawns(p)
	if p._respawnTimer > 0 and round_end == 0 then
		p._respawnTimer = p._respawnTimer - 1
	else if p._respawnTimer > 0 and round_end == 1 then
		p._respawnTimer = p._respawnTimer -.5
	elseif p._respawnTimer == 0 then
		p._respawnTimer = -1
		p:teleport(p._playerTeam._teamSpawn[1])
		givePlayerWeapons(p)
		round_end = 0
	end
	end
end

function health_regen(p)
    if p._hit then
         if p._timeHit == 0 then
             p._hit = false
         else
             p._timeHit = p._timeHit-1
         end
    end
    if not p._hit and p.life < 150 and not p.dead then
        p:play_sound("energy refuel", 1)
        p.life = p.life + 1
        if p.life >=150 then 
            p.life = 150
            p._hit = true
            p._timeHit = regenTime * 2
        end
    elseif not p._hit and p.life < 300 and not p.dead then
        p:play_sound("energy refuel", 1.1)
        p.life = p.life + 1.1
        if p.life >=300 then 
            p.life = 300
            p._hit = true
            p._timeHit = regenTime * 3
        end
    elseif not p._hit and p.life < 450 and not p.dead then
        p:play_sound("energy refuel", 1.2)
        p.life = p.life + 1.2
        if p.life >= 450 then 
            p.life = 450
            p._hit = true
            p._timeHit = regenTime * 4
        end
    end
end

function depositMotes(p)
	if p.monster.polygon.index == p._playerTeam._bankLoc.index and p._isInvader == false then
		if p._playerTeam._blockerCount == 0 and p._playerTeam._primeState == -1 then
			if p.items["key"] >= small_blocker and p.items["key"] < medium_blocker then
				spawnBlocker(p._playerTeam._enemyTeam, 3)
				
			end
			if p.items["key"] >= medium_blocker and p.items["key"] <= large_blocker then
				spawnBlocker(p._playerTeam._enemyTeam, 4)
				
			end
			if p.items["key"] > large_blocker then
				spawnBlocker(p._playerTeam._enemyTeam, 5)
				
			end
			if p.items["key"] ~= 0 then
				p:play_sound("chip insertion", 2)
				addPoints(p)			
			end
		end
	end
end

function spawnBlocker(team_to_block, combatant_number)

	Monsters.new(team_to_block._bankLoc.x, team_to_block._bankLoc.y, (0), team_to_block._bankLoc, (combatant_special[combatant_number]))
	team_to_block._blockerCount = team_to_block._blockerCount + 1
	for p in Players() do
		if p._playerTeam == team_to_block then 
			p:play_sound("alarm", 1)
		end	
	end
end

function blockerWaypoint()
	for m in Monsters() do 
		if m.valid and m.visible then
			if m.type == combatant_special[3] or m.type == combatant_special[4] or m.type == combatant_special[5] then
				--m.active = true
				local waypointZ = m.z + 1
			Effects.new(m.x, m.y, waypointZ, m.polygon, "defender spark")
			end
		end
	end
end

function highValueTarget(team)
	hvt = Game.random(2) + 1	
	if team._enemyTeam._score - team._score >= 20 and team._highValueTarget == 0 then
		spawn = pickSpawnLocation(team)
		Monsters.new(spawn.x, spawn.y, (0), spawn, (combatant_special[hvt]))
		team._highValueTarget = 1
		print("High Value Target on the field!")
	end
end

function deleteEmptyHeavy()
	for p in Players() do 
		if p.weapons["missile launcher"].primary.rounds == 0 and p.items["missile launcher"] ~= 0 then 
			p.items["missile launcher"] = 0
		elseif p.weapons["alien weapon"].primary.rounds == 0 and p.items["alien weapon"] ~= 0 then 
			p.items["alien weapon"] = 0
		elseif p.weapons["flamethrower"].primary.rounds == 0 and p.items["flamethrower"] ~= 0 then 
			p.items["flamethrower"] = 0
		end
	end
end

function addPoints(p)
	p.points = p.points + p.items["key"]
	p._playerTeam._score = p._playerTeam._score + p.items["key"]
	if p._playerTeam._score > maxScores then
		p._playerTeam._score = maxScores
	end
	p.items["key"] = 0
end

function updatePotentialScore(team)
	team._potentialScore = 0
	for p in Players() do
		if p._playerTeam == team then
			team._potentialScore = team._potentialScore + p.items["key"]
		end
	end
end
		
function invasions(p)
	if p.monster.polygon.index == p._playerTeam._teleporterLoc.index and p._playerTeam._teleporterState == 1 and p.life ~= 0 then
		p._isInvader = true
		p._invasionTimer = invasionDuration
		p._invaderKillCount = 0
		p.infravision_duration = invasionDuration
		p._invader = 0
		p._playerTeam._currentlyInvading = true
		p._playerTeam._invader = p
		p._playerTeam._teamInvasionTimer = invasionDuration
		p._playerTeam._invaderMonsterIndex = p.monster.index
		p._playerTeam._teleporterState = -1
		p._playerTeam._invasionCount = p._playerTeam._invasionCount + 1
		p._playerTeam._timeOfLastInvasion = timer
		if p._isInvader == true and p._invader ~= 1 then
		p.life = 300
		p._invader = 1
		end
		zoneSelect = Game.global_random(2) + 1
		if zoneSelect == 1 then
			zone = p._playerTeam._enemyTeam._spawnZone1
			p:teleport(zone[Game.global_random(#zone) + 1])
		elseif zoneSelect == 2 then
			zone = p._playerTeam._enemyTeam._spawnZone2
			p:teleport(zone[Game.global_random(#zone) + 1])
		elseif zoneSelect == 3 then
			zone = p._playerTeam._enemyTeam._spawnZone3
			p:teleport(zone[Game.global_random(#zone) + 1])
		end
		for q in Players() do
			if q.team.index ~= p.team.index then
				q:fade_screen("red")
				q:play_sound("siren", 1)
			end
		end
	end
	if p._invasionTimer > 0 and p._isInvader then
		p._invasionTimer = p._invasionTimer - 1
	elseif p._invasionTimer == 0 and p._isInvader then
		p._isInvader = false
		p._playerTeam._currentlyInvading = false
		if p.life > 150 then
			p.life = 150
		end
		p._playerTeam._invader = 0
		p._playerTeam._invaderMonsterIndex = -1
		p:teleport(p._playerTeam._teamSpawn[1])
		p._invader = 0
	end
end

function notifications(p)
	--BANK STATUS
	if p._playerTeam._blockerCount >= 1 and p._playerTeam._primeState ~= 1 then 
		p.overlays[0].color = "red"
		p.overlays[0].text = "BANK: BLOCKED"
	elseif p._playerTeam._blockerCount == 0 and p._playerTeam._primeState ~= 1 then
		p.overlays[0].color = "white"
		p.overlays[0].text = "BANK: OPEN"
	elseif p._playerTeam._primeState == 1 then 
		p.overlays[0].text = "Damage boost ".. p._playerTeam._envoysKilled
	end
	--INVASION TIMER
	if p._playerTeam._enemyTeam._currentlyInvading == true then 
		p.overlays[1].color = "red"
		p.overlays[1].text = p._playerTeam._enemyTeam._invader._invasionTimer
	elseif p._isInvader then
		p.overlays[1].color = "red"
		p.overlays[1].text = p._invasionTimer
	elseif p._playerTeam._enemyTeam._currentlyInvading ~= true then
		p.overlays[1].color = "white"
		p.overlays[1].text = "--:--"
	end
	--TEAM SCORE/PRIMEVAL HEALTH ONCE MAX SCORE REACHED
	if p._playerTeam._primeState == 1 then
		p.overlays[2].color = "yellow"
		p.overlays[2].text = p._playerTeam._prime.vitality
	elseif p._playerTeam._score <= maxScores or p._playerTeam._roundsWon == 2 or p._playerTeam._enemyTeam._roundsWon == 2 then 	
		p.overlays[2].color = "white"
		p.overlays[2].text = p._playerTeam._score .."(".. p._playerTeam._potentialScore ..")"
	end
	--ROUNDS WON/ENEMY ROUNDS WON
		p.overlays[3].color = "white"
		p.overlays[3].text = p._playerTeam._roundsWon .."/".. p._playerTeam._enemyTeam._roundsWon
	--ENEMY TEAM SCORE/PRIMEVAL HEALTH ONCE MAX SCORE IS REACHED
	if p._playerTeam._enemyTeam._primeState == 1 then
		p.overlays[4].color = "yellow"
		p.overlays[4].text = p._playerTeam._enemyTeam._prime.vitality
	elseif p._playerTeam._score <= maxScores or p._playerTeam._roundsWon == 2 or p._playerTeam._enemyTeam._roundsWon == 2 then 	
		p.overlays[4].color = "white"
		p.overlays[4].text = p._playerTeam._enemyTeam._score .."(".. p._playerTeam._enemyTeam._potentialScore ..")"	
	--NUMBER OF MOTES HELD/NUMBER HELD BY TARGET WHEN INVADING	
		--p.overlays[5]:clear()
		if p.items["key"] == 1 then
			p.overlays[5].text = "You have "..p.items["key"].." Mote"
		elseif p.items["key"] ~= 1 then
			p.overlays[5].text = "You have "..p.items["key"].." Motes"
			if p._isInvader then
				local x,y,z,polygon,t
				t,x,y,z,polygon = p:find_target()
				if t ~= nil then
					for pt in Players() do
						if pt.monster.index == t.index then
							p.overlays[5].text = "Enemy has " ..pt.items["key"].. " Motes"
						end
					end
				end
			end
		end 
	end
	
	if p._playerTeam._primeSpawnDelay == 1 then
	Players.print(p._playerTeam._color .. " Primeval spawned!")
	p:play_sound("alien harmonics", 1)
	elseif p._playerTeam._enemyTeam._primeSpawnDelay == 1 then --I MADE A CHANGE HERE IF THIS IS BROKEN THIS IS WHY  
	p:play_sound("alien harmonics", 1)
	Players.print(p._playerTeam._enemyTeam._color .. " Primeval spawned!")
	hvtMessage = 0
	elseif p._playerTeam._highValueTarget == 1 and hvtMessage == 0 then
		--p._playerTeam.print("High Value Target on the field!")
		hvtMessage = 1
	end
end

function item_life(item)
    if item.type == "key" then
		item._life = item._life - 1
		if item._life == 0 then
			item:delete()
		end
    end
end

function primeval(team)
	if team._score == maxScores and team._primeState == -1 then
		if team._primeSpawnDelay == 0 then
			prime = Monsters.new(team._bankLoc.x, team._bankLoc.y, (0), team._bankLoc, (combatant_special[7]))
			Monsters.new(team._bankLoc.x, team._bankLoc.y, (0), team._bankLoc, (combatant_special[6]))
			
			Monsters.new(team._bankLoc.x, team._bankLoc.y, (0), team._bankLoc, (combatant_special[6]))
			
			Monsters.new(team._bankLoc.x, team._bankLoc.y, (0), team._bankLoc, (combatant_special[6]))
			
			team._primeState = 1
			team._prime = prime
		else
			team._primeSpawnDelay = team._primeSpawnDelay - 1
		end
	end
end

function round_timer()
	timer = timer + 1
end

function Triggers.player_revived(player)
	player._respawnTimer = masterRespawnTimer
end

function Triggers.player_damaged(victim, aggressor_player, aggressor_monster, damage_type, damage_amount, projectile)
    if victim._isInvader and projectile and not aggressor_player then
        victim.life = victim.life + damage_amount
    end
    victim._hit = true
	if victim.life < 150 then
		victim._timeHit = regenTime
	elseif victim.life < 300 then
		victim._timeHit = regenTime * 2
	else
		victim._timeHit = regenTime * 3
	end
end

function Triggers.player_killed(player, aggressor_player, action, projectile)
	if player._isInvader then
		player._isInvader = false
		player._invasionTimer = 0
		player.infravision_duration = 0
		player._playerTeam._currentlyInvading = false
		player._playerTeam._invader = p
		player._playerTeam._invaderMonsterIndex = -1 --p.monster.index
		player.infravision_duration = 0
	elseif aggressor_player ~= nil then
		if aggressor_player._isInvader then
		Players.print("Invader "..aggressor_player.name.." killed "..player.name)
			aggressor_player._invaderKillCount = aggressor_player._invaderKillCount + 1
			for m in Monsters() do
				if m.type == combatant_special[7] and m.index == player._playerTeam._prime.index then
					m.vitality = m.vitality + primevalHealthOnKill
					if m.vitality > primevalMaxHealth then
						m.vitality = primevalMaxHealth
					end
				end
			end
			if aggressor_player._invaderKillCount >= 4 then
				aggressor_player._isInvader = false
				aggressor_player._invasionTimer = 0
				aggressor_player.infravision_duration = 0
				if aggressor_player.life > 150 then
					aggressor_player.life = 150
				end
				aggressor_player._playerTeam._currentlyInvading = false
				aggressor_player._playerTeam._invader0 = 0
				aggressor_player._playerTeam._invaderMonsterIndex = -1
				aggressor_player:teleport(aggressor_player._playerTeam._teamSpawn[1])
				p._invader = 0
			end
		end	
	end
	
	if player.items["key"] > 0 then
		Players.print(player.name.." dropped "..player.items["key"].." motes")
	end
	player.items["key"] = 0
end
	
function Triggers.monster_damaged(monster, aggressor_monster, damage_type, damage_amount, projectile)	
	if aggressor_monster ~= nil then
		--player attacks monster
		if aggressor_monster.type == "player" and monster.type ~= "player" then
			--if player is invader
			if aggressor_monster.index == RedTeam._invaderMonsterIndex or aggressor_monster.index == BluTeam._invaderMonsterIndex then
				monster.vitality = monster.vitality + damage_amount
			--if player isnt invader and attacks prime
			else
                if RedTeam._prime ~= 0 then
                    if monster.type == combatant_special[7] and RedTeam._prime.index == monster.index then
                        damage_amount = (damage_amount + (damage_amount * (RedTeam._envoysKilled / 10)))
                       -- Players.print(damage_amount)
                    end
                end
                if BluTeam._prime ~= 0 then
                    if monster.type == combatant_special[7] and BluTeam._prime.index == monster.index then
                        damage_amount = (damage_amount + (damage_amount * (BluTeam._envoysKilled / 10)))
                    end
                end
            end
		elseif aggressor_monster.type ~= "player" and monster.type ~= "player" then
			monster.vitality = monster.vitality + damage_amount
		end
	end
end

function Triggers.monster_killed(monster, aggressor_player, projectile)
	if aggressor_player ~= nil and aggressor_player._playerTeam._primeState ~= 1 then

		for k,v in pairs(combatant_grunt) do 
			if monster.type == v then
            aggressor_player._playerTeam._monsterCount = aggressor_player._playerTeam._monsterCount - 1
            spawnKeyHelper(monster, 0)
            spawnAmmoHelper(monster)
			break
			end
		end
		for k,v in pairs(combatant_anchor) do
			if monster.type == v then
			aggressor_player._playerTeam._monsterCount = aggressor_player._playerTeam._monsterCount - 1
            spawnKeyHelper(monster, 1)
            spawnAmmoHelper(monster)
			break
			end
		end
		if monster.type == combatant_special[3] or monster.type == combatant_special[4] or monster.type == combatant_special[5] then
			aggressor_player._playerTeam._blockerCount = aggressor_player._playerTeam._blockerCount - 1
		--	spawnAmmoHelper(monster)
		--	spawnAmmoHelper(monster)
		elseif monster.type == combatant_special[1] or monster.type == combatant_special[2] then
		spawnKeyHelper(monster, 7)
		end
	--After Prime Spawns
	elseif aggressor_player ~= nil then
		if monster.type == combatant_special[7] then
			aggressor_player._playerTeam._roundsWon = aggressor_player._playerTeam._roundsWon + 1
			prime_killed = 1
			round_over()
		elseif monster.type == combatant_special[6] then
			aggressor_player._playerTeam._envoysKilled = aggressor_player._playerTeam._envoysKilled + 1
		end
	end
--	Players.print(mon._team)
end

function spawnKeyHelper(monster, quantity, team)
	--if team._primeState ~= 1 then 
		for i = 0,quantity,1 do
		x_rand = (Game.global_random(100)*.01)
		y_rand = (Game.global_random(100)*.01)
		Items.new(monster.x + x_rand, monster.y + y_rand, .25, monster.polygon, "key")
		end
	--end
end

function spawnAmmoHelper(monster)
	AmmoSmall(monster)
	AmmoMedium(monster)
	--AmmoHeavy(monster)
end

function AmmoSmall(monsterguy)
	small_ammo_pistol = Game.random(3)
	if small_ammo_pistol == 2 then 
		Items.new(monsterguy.x, monsterguy.y, .10, monsterguy.polygon, "pistol ammo")
	end
	small_ammo_fusion = Game.random(3)
	if small_ammo_fusion == 2 then 
		Items.new(monsterguy.x, monsterguy.y, .10, monsterguy.polygon, "fusion pistol ammo")
	end
end

function AmmoMedium(monsterguy)	
	medium_ammo_ar = Game.random(5)
	if medium_ammo_ar == 4 then
		Items.new(monsterguy.x, monsterguy.y, .10, monsterguy.polygon, "assault rifle ammo")
	end	
	medium_ammo_grenade = Game.random(5)
	if medium_ammo_grenade == 4 then
		Items.new(monsterguy.x, monsterguy.y, .10, monsterguy.polygon, "assault rifle grenades")
	end
	medium_ammo_shotgun = Game.random(5)
	if medium_ammo_shotgun == 4 then
		Items.new(monsterguy.x, monsterguy.y, .10, monsterguy.polygon, "shotgun ammo")
	end
	medium_ammo_shotgun = Game.random(5)
	if medium_ammo_shotgun == 4 then
		Items.new(monsterguy.x, monsterguy.y, .10, monsterguy.polygon, "shotgun")
	end
	medium_ammo_smg = Game.random(5)
	if medium_ammo_smg == 4 then
		Items.new(monsterguy.x, monsterguy.y, .10, monsterguy.polygon, "smg ammo")
	end
end

--[[function AmmoHeavy(monsterguy)
	heavy_ammo_missile = Game.random(20)
	if heavy_ammo_missile == 19 then
		Items.new(monsterguy.x, monsterguy.y, .10, monsterguy.polygon, "missile launcher ammo")
	end
	heavy_ammo_flamethrower = Game.random(20)
	if heavy_ammo_flamethrower == 19 then
		Items.new(monsterguy.x, monsterguy.y, .10, monsterguy.polygon, "flamethrower ammo")
	end
	heavy_ammo_alien = Game.random(20)
	if heavy_ammo_alien == 19 then
		Items.new(monsterguy.x, monsterguy.y, .10, monsterguy.polygon, "alien weapon ammo")
	end
end--]]

function Triggers.item_created(item)
    if item.type == "key" then
		item._life = moteLife
    end
end

function round_over()
	if RedTeam._roundsWon == 2 or BluTeam._roundsWon == 2 then
		Game.over = true
	else
		for m in Monsters() do
			if m.type ~= "player" and m.type ~= "explodavacbob" then
			m:position(0,0,0, monster_crusher) 
			end
		end
		for i in Items() do
			i:delete()
		end
		for p in Players() do
			p:teleport(p._playerTeam._shipSpawn)
			p.items["key"] = 0
		end
		setUpPlayers()
		setUpZones()
		resetTeam(RedTeam)
		resetTeam(BluTeam)
		timer = -1 	
		round_end = 1
	end
end

function resetTeam(team)
	team._currentlyInvading = false
	team._invader = 0
	team._invaderMonsterIndex = -1
	team._invasionCount = 0
	team._timeOfLastInvasion = 0
	team._teleporterState = -1
	team._score = 0
	team._currentMonsterSpawnZone = StartingZone
	team._monsterCount = 0
	team._spawningDudes = false
	team._blockerCount = 0
	team._envoysKilled = 0
	team._primeState = -1
	team._prime = 0
	team._primeSpawnDelay = primevalSpawnDelay
end
